/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class HtmlBlockGeneratorGUI
extends JFrame {
    private JPanel mainContentPanel;
    private JTextArea outputTextArea;
    private Map<String, JPanel> blockPanels;
    private String currentBlockType = "";

    public HtmlBlockGeneratorGUI() {
        this.setTitle("HTML Block Generator");
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        JPanel selectionPanel = new JPanel(new FlowLayout(0));
        selectionPanel.setBorder(BorderFactory.createTitledBorder("Blocktyp ausw\u00e4hlen"));
        JComboBox<String> blockTypeComboBox = new JComboBox<String>();
        blockTypeComboBox.addItem("Bitte w\u00e4hlen...");
        blockTypeComboBox.addItem("1. \u00dcberschrift");
        blockTypeComboBox.addItem("2. Text-Block");
        blockTypeComboBox.addItem("3. Definitionsblock");
        blockTypeComboBox.addItem("4. Codeblock");
        blockTypeComboBox.addItem("5. Aufgabenblock");
        blockTypeComboBox.addItem("6. Kleiner Exkurs");
        blockTypeComboBox.addItem("7. Gro\u00dfer Exkurs");
        blockTypeComboBox.addItem("8. Testaufgaben");
        blockTypeComboBox.addItem("9. Videoblock");
        blockTypeComboBox.addItem("10. Text mit Bild links");
        blockTypeComboBox.addItem("11. Text mit Bild rechts");
        blockTypeComboBox.addItem("12. Bilderreihe");
        blockTypeComboBox.addItem("13. Galerie");
        blockTypeComboBox.addItem("14. Tabellen");
        blockTypeComboBox.addItem("15. Downloadlinks");
        this.blockPanels = new LinkedHashMap<String, JPanel>();
        blockTypeComboBox.addActionListener(e -> {
            String selectedItem = (String)blockTypeComboBox.getSelectedItem();
            this.displayBlockPanel(selectedItem);
            this.currentBlockType = selectedItem;
            this.outputTextArea.setText("");
        });
        selectionPanel.add(blockTypeComboBox);
        this.add((Component)selectionPanel, "North");
        this.mainContentPanel = new JPanel();
        this.mainContentPanel.setLayout(new CardLayout());
        this.mainContentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.mainContentPanel, "Center");
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setBorder(BorderFactory.createTitledBorder("Generierter HTML-Code"));
        this.outputTextArea = new JTextArea(10, 60);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.outputTextArea);
        JButton copyButton = new JButton("Code kopieren");
        copyButton.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(this.outputTextArea.getText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            JOptionPane.showMessageDialog(this, "HTML-Code in die Zwischenablage kopiert!");
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(copyButton);
        outputPanel.add((Component)scrollPane, "Center");
        outputPanel.add((Component)buttonPanel, "South");
        this.add((Component)outputPanel, "South");
        this.initializeBlockPanels();
        this.setVisible(true);
    }

    private void initializeBlockPanels() {
        JPanel headingPanel = this.createHeadingPanel();
        this.blockPanels.put("1. \u00dcberschrift", headingPanel);
        this.mainContentPanel.add((Component)headingPanel, "1. \u00dcberschrift");
        JPanel textBlockPanel = this.createTextBlockPanel();
        this.blockPanels.put("2. Text-Block", textBlockPanel);
        this.mainContentPanel.add((Component)textBlockPanel, "2. Text-Block");
        JPanel definitionBlockPanel = this.createDefinitionBlockPanel();
        this.blockPanels.put("3. Definitionsblock", definitionBlockPanel);
        this.mainContentPanel.add((Component)definitionBlockPanel, "3. Definitionsblock");
        JPanel codeBlockPanel = this.createCodeBlockPanel();
        this.blockPanels.put("4. Codeblock", codeBlockPanel);
        this.mainContentPanel.add((Component)codeBlockPanel, "4. Codeblock");
        JPanel taskBlockPanel = this.createTaskBlockPanel();
        this.blockPanels.put("5. Aufgabenblock", taskBlockPanel);
        this.mainContentPanel.add((Component)taskBlockPanel, "5. Aufgabenblock");
        JPanel smallExcursionPanel = this.createCollapsibleBlockPanel(false);
        this.blockPanels.put("6. Kleiner Exkurs", smallExcursionPanel);
        this.mainContentPanel.add((Component)smallExcursionPanel, "6. Kleiner Exkurs");
        JPanel largeExcursionPanel = this.createCollapsibleBlockPanel(true);
        this.blockPanels.put("7. Gro\u00dfer Exkurs", largeExcursionPanel);
        this.mainContentPanel.add((Component)largeExcursionPanel, "7. Gro\u00dfer Exkurs");
        JPanel testBlockPanel = this.createTestBlockPanel();
        this.blockPanels.put("8. Testaufgaben", testBlockPanel);
        this.mainContentPanel.add((Component)testBlockPanel, "8. Testaufgaben");
        JPanel videoBlockPanel = this.createVideoBlockPanel();
        this.blockPanels.put("9. Videoblock", videoBlockPanel);
        this.mainContentPanel.add((Component)videoBlockPanel, "9. Videoblock");
        JPanel textImageLeftPanel = this.createTextImageBlockPanel("left");
        this.blockPanels.put("10. Text mit Bild links", textImageLeftPanel);
        this.mainContentPanel.add((Component)textImageLeftPanel, "10. Text mit Bild links");
        JPanel textImageRightPanel = this.createTextImageBlockPanel("right");
        this.blockPanels.put("11. Text mit Bild rechts", textImageRightPanel);
        this.mainContentPanel.add((Component)textImageRightPanel, "11. Text mit Bild rechts");
        JPanel imageRowPanel = this.createImageRowBlockPanel();
        this.blockPanels.put("12. Bilderreihe", imageRowPanel);
        this.mainContentPanel.add((Component)imageRowPanel, "12. Bilderreihe");
        JPanel galleryPanel = this.createGalleryBlockPanel();
        this.blockPanels.put("13. Galerie", galleryPanel);
        this.mainContentPanel.add((Component)galleryPanel, "13. Galerie");
        JPanel tablePanel = this.createTableBlockPanel();
        this.blockPanels.put("14. Tabellen", tablePanel);
        this.mainContentPanel.add((Component)tablePanel, "14. Tabellen");
        JPanel downloadLinkPanel = this.createDownloadLinkPanel();
        this.blockPanels.put("15. Downloadlinks", downloadLinkPanel);
        this.mainContentPanel.add((Component)downloadLinkPanel, "15. Downloadlinks");
    }

    private void displayBlockPanel(String panelName) {
        CardLayout cl = (CardLayout)this.mainContentPanel.getLayout();
        cl.show(this.mainContentPanel, panelName);
    }

    private JComboBox<String> createThemeComboBox() {
        String[] themes = new String[]{"Praktische Informatik (practical)", "Angewandte Informatik (applied)", "Theoretische Informatik (theoretical)", "Technische Informatik (technical)", "Externe Partner (partner)", "Lehrplanumsetzung (lehrplan)"};
        return new JComboBox<String>(themes);
    }

    private String getSelectedThemeClass(JComboBox<String> comboBox) {
        String selected = (String)comboBox.getSelectedItem();
        if (selected == null) {
            return "practical";
        }
        if (selected.contains("practical")) {
            return "practical";
        }
        if (selected.contains("applied")) {
            return "applied";
        }
        if (selected.contains("theoretical")) {
            return "theoretical";
        }
        if (selected.contains("technical")) {
            return "technical";
        }
        if (selected.contains("partner")) {
            return "partner";
        }
        if (selected.contains("lehrplan")) {
            return "lehrplan";
        }
        return "practical";
    }

    private JPanel createHeadingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u00dcberschrift-Block Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("\u00dcberschriftentyp (h2, h3, h4):"), gbc);
        gbc.gridx = 1;
        JTextField headingTagField = new JTextField(10);
        panel.add((Component)headingTagField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("ID f\u00fcr Navigation:"), gbc);
        gbc.gridx = 1;
        JTextField idField = new JTextField(20);
        panel.add((Component)idField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Text der \u00dcberschrift:"), gbc);
        gbc.gridx = 1;
        JTextField titleTextField = new JTextField(30);
        panel.add((Component)titleTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String headingTag = headingTagField.getText().trim();
            String id = idField.getText().trim();
            String titleText = titleTextField.getText().trim();
            if (!headingTag.matches("h[2-4]")) {
                JOptionPane.showMessageDialog(this, "Ung\u00fcltiger \u00dcberschriftentyp. Nur h2, h3 oder h4 sind erlaubt.", "Fehler", 0);
                return;
            }
            if (id.isEmpty() || titleText.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Felder aus.", "Fehler", 0);
                return;
            }
            String html = String.format("<div class=\"heading-block\" id=\"%s\">\n    <%s>%s</%s>\n</div>", id, headingTag, titleText, headingTag);
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createTextBlockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Text-Block Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)new JLabel("Textinhalt (Jeder Absatz wird mit <p> umgeben. F\u00fcr Listen <ol>/<ul> direkt eingeben):"), gbc);
        gbc.gridy = 1;
        JTextArea contentTextArea = new JTextArea(10, 50);
        contentTextArea.setLineWrap(true);
        contentTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(contentTextArea);
        panel.add((Component)scrollPane, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String[] lines;
            String rawContent = contentTextArea.getText();
            StringBuilder formattedContent = new StringBuilder();
            String[] stringArray = lines = rawContent.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">")) {
                    formattedContent.append("    ").append(trimmedLine).append("\n");
                } else if (!trimmedLine.isEmpty()) {
                    formattedContent.append("    <p>\n        ").append(trimmedLine).append("\n    </p>\n");
                } else {
                    formattedContent.append("\n");
                }
                ++n2;
            }
            String html = String.format("<div class=\"text-block\">\n%s</div>", formattedContent.toString().trim());
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createDefinitionBlockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Definitionsblock Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Thema (Farbe des Blocks):"), gbc);
        gbc.gridx = 1;
        JComboBox<String> themeComboBox = this.createThemeComboBox();
        panel.add(themeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Pr\u00e4fix (z.B. 'Definition:'):"), gbc);
        gbc.gridx = 1;
        JTextField prefixField = new JTextField(20);
        prefixField.setText("Definition:");
        panel.add((Component)prefixField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Begriff:"), gbc);
        gbc.gridx = 1;
        JTextField termField = new JTextField(30);
        panel.add((Component)termField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Definitionstext:"), gbc);
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JTextArea definitionTextArea = new JTextArea(8, 50);
        definitionTextArea.setLineWrap(true);
        definitionTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(definitionTextArea);
        panel.add((Component)scrollPane, gbc);
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String[] lines;
            String themeClass = this.getSelectedThemeClass(themeComboBox);
            String prefix = prefixField.getText().trim();
            String term = termField.getText().trim();
            String rawDefinition = definitionTextArea.getText();
            if (term.isEmpty() || rawDefinition.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie den Begriff und den Definitionstext aus.", "Fehler", 0);
                return;
            }
            StringBuilder formattedDefinition = new StringBuilder();
            String[] stringArray = lines = rawDefinition.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">")) {
                    formattedDefinition.append("                    ").append(trimmedLine).append("\n");
                } else if (!trimmedLine.isEmpty()) {
                    formattedDefinition.append("                    <p>").append(trimmedLine).append("</p>\n");
                } else {
                    formattedDefinition.append("\n");
                }
                ++n2;
            }
            String html = String.format("<div class=\"definition-block\">\n    <img src=\"../../Bilder/Symbol-Defintion.png\" alt=\"Definition\" class=\"definition-icon-floated\">\n\n    <div class=\"definition-header\">\n        <div class=\"title-content\">\n            <span class=\"prefix\">%s</span>\n            <span class=\"term-%s\">%s</span>\n        </div>\n    </div>\n\n    <div class=\"definition-body\">\n%s    </div>\n</div>", prefix, themeClass, term, formattedDefinition.toString().trim());
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createCodeBlockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Codeblock Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Titel des Codeblocks:"), gbc);
        gbc.gridx = 1;
        JTextField codeTitleField = new JTextField(30);
        panel.add((Component)codeTitleField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Sprache (java, python, html, pascal, markup, css, javascript, prolog):"), gbc);
        gbc.gridx = 1;
        JTextField languageField = new JTextField(20);
        panel.add((Component)languageField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Code Inhalt (f\u00fcr HTML-Klammern &lt; und &gt; verwenden!):"), gbc);
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JTextArea codeContentTextArea = new JTextArea(12, 60);
        codeContentTextArea.setLineWrap(false);
        codeContentTextArea.setWrapStyleWord(false);
        JScrollPane scrollPane = new JScrollPane(codeContentTextArea);
        panel.add((Component)scrollPane, gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String codeTitle = codeTitleField.getText().trim();
            String language = languageField.getText().trim().toLowerCase();
            String codeContent = codeContentTextArea.getText();
            if (codeTitle.isEmpty() || language.isEmpty() || codeContent.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Felder aus.", "Fehler", 0);
                return;
            }
            CharSequence[] supportedLanguages = new String[]{"java", "python", "html", "pascal", "markup", "css", "javascript", "prolog"};
            boolean languageSupported = false;
            CharSequence[] charSequenceArray = supportedLanguages;
            int n = supportedLanguages.length;
            int n2 = 0;
            while (n2 < n) {
                String lang = charSequenceArray[n2];
                if (lang.equals(language)) {
                    languageSupported = true;
                    break;
                }
                ++n2;
            }
            if (!languageSupported) {
                JOptionPane.showMessageDialog(this, "Ung\u00fcltige Sprache. Unterst\u00fctzte Sprachen: " + String.join((CharSequence)", ", supportedLanguages), "Fehler", 0);
                return;
            }
            String html = String.format("<div class=\"code-container\">\n    <div class=\"code-header\">\n        <span>%s</span>\n        <button class=\"copy-button\">Kopieren</button>\n    </div>\n    <pre><code class=\"language-%s\">\n%s    </code></pre>\n</div>", codeTitle, language, codeContent);
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createTaskBlockPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Aufgabenblock Einstellungen"));
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        inputPanel.add((Component)new JLabel("Thema (Farbe des Blocks):"), gbc);
        gbc.gridx = 1;
        JComboBox<String> themeComboBox = this.createThemeComboBox();
        inputPanel.add(themeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        inputPanel.add((Component)new JLabel("Pr\u00e4fix (z.B. '\u00dcbung -'):"), gbc);
        gbc.gridx = 1;
        JTextField prefixField = new JTextField(20);
        prefixField.setText("\u00dcbung -");
        inputPanel.add((Component)prefixField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        inputPanel.add((Component)new JLabel("Titel des Aufgabenblocks:"), gbc);
        gbc.gridx = 1;
        JTextField titleField = new JTextField(30);
        inputPanel.add((Component)titleField, gbc);
        JPanel tasksContainerPanel = new JPanel();
        tasksContainerPanel.setLayout(new BoxLayout(tasksContainerPanel, 1));
        JScrollPane tasksScrollPane = new JScrollPane(tasksContainerPanel);
        tasksScrollPane.setPreferredSize(new Dimension(600, 300));
        tasksScrollPane.setBorder(BorderFactory.createTitledBorder("Aufgaben"));
        AtomicInteger taskCounter = new AtomicInteger(1);
        Runnable addTask = () -> {
            JPanel singleTaskPanel = new JPanel(new GridBagLayout());
            singleTaskPanel.setBorder(BorderFactory.createTitledBorder("Aufgabe " + taskCounter.getAndIncrement()));
            GridBagConstraints taskGbc = new GridBagConstraints();
            taskGbc.insets = new Insets(5, 5, 5, 5);
            taskGbc.fill = 1;
            taskGbc.weightx = 1.0;
            taskGbc.gridx = 0;
            taskGbc.gridy = 0;
            taskGbc.gridwidth = 2;
            singleTaskPanel.add((Component)new JLabel("Kurze \u00dcberschrift der Aufgabe:"), taskGbc);
            taskGbc.gridy = 1;
            JTextField taskHeadingField = new JTextField(40);
            singleTaskPanel.add((Component)taskHeadingField, taskGbc);
            taskGbc.gridy = 2;
            singleTaskPanel.add((Component)new JLabel("Aufgabentext:"), taskGbc);
            taskGbc.gridy = 3;
            taskGbc.weighty = 1.0;
            JTextArea taskContentArea = new JTextArea(5, 40);
            taskContentArea.setLineWrap(true);
            taskContentArea.setWrapStyleWord(true);
            JScrollPane taskContentScrollPane = new JScrollPane(taskContentArea);
            singleTaskPanel.add((Component)taskContentScrollPane, taskGbc);
            taskGbc.gridy = 4;
            taskGbc.weighty = 0.0;
            singleTaskPanel.add((Component)new JLabel("L\u00f6sungstext (nur f\u00fcr Lehrer sichtbar):"), taskGbc);
            taskGbc.gridy = 5;
            taskGbc.weighty = 1.0;
            JTextArea solutionContentArea = new JTextArea(5, 40);
            solutionContentArea.setLineWrap(true);
            solutionContentArea.setWrapStyleWord(true);
            JScrollPane solutionContentScrollPane = new JScrollPane(solutionContentArea);
            singleTaskPanel.add((Component)solutionContentScrollPane, taskGbc);
            singleTaskPanel.putClientProperty("taskHeading", taskHeadingField);
            singleTaskPanel.putClientProperty("taskContent", taskContentArea);
            singleTaskPanel.putClientProperty("solutionContent", solutionContentArea);
            tasksContainerPanel.add(singleTaskPanel);
            tasksContainerPanel.revalidate();
            tasksContainerPanel.repaint();
            tasksScrollPane.getVerticalScrollBar().setValue(tasksScrollPane.getVerticalScrollBar().getMaximum());
        };
        JButton addTaskButton = new JButton("Aufgabe hinzuf\u00fcgen");
        addTaskButton.addActionListener(e -> addTask.run());
        addTask.run();
        panel.add((Component)inputPanel, "North");
        panel.add((Component)tasksScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(addTaskButton);
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String themeClass = this.getSelectedThemeClass(themeComboBox);
            String prefix = prefixField.getText().trim();
            String title = titleField.getText().trim();
            if (prefix.isEmpty() || title.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie Pr\u00e4fix und Titel des Aufgabenblocks aus.", "Fehler", 0);
                return;
            }
            StringBuilder allTasksHtml = new StringBuilder();
            Component[] componentArray = tasksContainerPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JPanel) {
                    String[] solutionLines;
                    String[] taskLines;
                    JPanel taskPanel = (JPanel)comp;
                    JTextField taskHeadingField = (JTextField)taskPanel.getClientProperty("taskHeading");
                    JTextArea taskContentArea = (JTextArea)taskPanel.getClientProperty("taskContent");
                    JTextArea solutionContentArea = (JTextArea)taskPanel.getClientProperty("solutionContent");
                    String taskHeading = taskHeadingField.getText().trim();
                    String rawTaskContent = taskContentArea.getText();
                    String rawSolutionContent = solutionContentArea.getText();
                    if (taskHeading.isEmpty() || rawTaskContent.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Aufgabenfelder aus.", "Fehler", 0);
                        return;
                    }
                    StringBuilder formattedTaskContent = new StringBuilder();
                    String[] stringArray = taskLines = rawTaskContent.split("\n");
                    int n3 = taskLines.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray[n4];
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") || trimmedLine.startsWith("&lt;")) {
                            formattedTaskContent.append("                            ").append(trimmedLine).append("\n");
                        } else if (!trimmedLine.isEmpty()) {
                            formattedTaskContent.append("                            <p>").append(trimmedLine).append("</p>\n");
                        } else {
                            formattedTaskContent.append("\n");
                        }
                        ++n4;
                    }
                    StringBuilder formattedSolutionContent = new StringBuilder();
                    String[] stringArray2 = solutionLines = rawSolutionContent.split("\n");
                    int n5 = solutionLines.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String line = stringArray2[n6];
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") || trimmedLine.startsWith("&lt;")) {
                            formattedSolutionContent.append("                                ").append(trimmedLine).append("\n");
                        } else if (!trimmedLine.isEmpty()) {
                            formattedSolutionContent.append("                                <p>").append(trimmedLine).append("</p>\n");
                        } else {
                            formattedSolutionContent.append("\n");
                        }
                        ++n6;
                    }
                    allTasksHtml.append(String.format("                    <div class=\"task-item\">\n                        <h4>%s</h4>\n%s\n                        <div class=\"teacher-content solution-box\">\n                            <h5>L\u00f6sung</h5>\n%s                        </div>\n                    </div>\n", taskHeading, formattedTaskContent.toString().trim(), formattedSolutionContent.toString().trim()));
                }
                ++n2;
            }
            String html = String.format("<div class=\"task-block %s\">\n    <img src=\"../../Bilder/Symbol-Aufgabe.png\" alt=\"\u00dcbung\" class=\"task-icon-floated\">\n\n    <div class=\"task-header\">\n        <span class=\"prefix\">%s</span>\n        <span class=\"title\">%s</span>\n    </div>\n\n    <div class=\"task-body\">\n%s    </div>\n</div>", themeClass, prefix, title, allTasksHtml.toString().trim());
            this.outputTextArea.setText(html);
        });
        bottomPanel.add(generateButton);
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JPanel createCollapsibleBlockPanel(boolean isActiveDefault) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder((isActiveDefault ? "Gro\u00dfer Exkurs" : "Kleiner Exkurs") + " Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Thema (Farbe des Blocks):"), gbc);
        gbc.gridx = 1;
        JComboBox<String> themeComboBox = this.createThemeComboBox();
        panel.add(themeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Titel des Exkurses:"), gbc);
        gbc.gridx = 1;
        JTextField titleField = new JTextField(30);
        panel.add((Component)titleField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Inhalt des Exkurses (beliebiger HTML-Code):"), gbc);
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JTextArea contentTextArea = new JTextArea(10, 50);
        contentTextArea.setLineWrap(true);
        contentTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(contentTextArea);
        panel.add((Component)scrollPane, gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String activeClass;
            String themeClass = this.getSelectedThemeClass(themeComboBox);
            String title = titleField.getText().trim();
            String rawContent = contentTextArea.getText();
            String string = activeClass = isActiveDefault ? " active" : "";
            if (title.isEmpty() || rawContent.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Felder aus.", "Fehler", 0);
                return;
            }
            String html = String.format("<div class=\"collapsible-task-block %s%s\">\n    <img src=\"../../Bilder/Symbol-Exkurs.png\" alt=\"Icon Beschreibung\" class=\"collapsible-icon-floated\">\n    <div class=\"collapsible-header\">\n        <span class=\"title\">%s</span>\n        <i class=\"fas fa-chevron-up toggle-icon\"></i>\n    </div>\n    <div class=\"collapsible-content\">\n        <div class=\"text-block\">\n%s        </div>\n    </div>\n</div>", themeClass, activeClass, title, this.indentHtmlContent(rawContent, 4));
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createTestBlockPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Testaufgaben Block Einstellungen"));
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        inputPanel.add((Component)new JLabel("Thema (Farbe des Blocks):"), gbc);
        gbc.gridx = 1;
        JComboBox<String> themeComboBox = this.createThemeComboBox();
        inputPanel.add(themeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        inputPanel.add((Component)new JLabel("Haupttitel des Testblocks:"), gbc);
        gbc.gridx = 1;
        JTextField mainTitleField = new JTextField(30);
        inputPanel.add((Component)mainTitleField, gbc);
        JPanel testItemsContainerPanel = new JPanel();
        testItemsContainerPanel.setLayout(new BoxLayout(testItemsContainerPanel, 1));
        JScrollPane testItemsScrollPane = new JScrollPane(testItemsContainerPanel);
        testItemsScrollPane.setPreferredSize(new Dimension(600, 300));
        testItemsScrollPane.setBorder(BorderFactory.createTitledBorder("Testaufgaben"));
        AtomicInteger testCounter = new AtomicInteger(1);
        Runnable addTestItem = () -> {
            JPanel singleTestItemPanel = new JPanel(new GridBagLayout());
            singleTestItemPanel.setBorder(BorderFactory.createTitledBorder("Testaufgabe " + testCounter.getAndIncrement()));
            GridBagConstraints itemGbc = new GridBagConstraints();
            itemGbc.insets = new Insets(5, 5, 5, 5);
            itemGbc.fill = 1;
            itemGbc.weightx = 1.0;
            itemGbc.gridx = 0;
            itemGbc.gridy = 0;
            itemGbc.gridwidth = 2;
            singleTestItemPanel.add((Component)new JLabel("Kurze \u00dcberschrift der Testaufgabe:"), itemGbc);
            itemGbc.gridy = 1;
            JTextField testHeadingField = new JTextField(40);
            singleTestItemPanel.add((Component)testHeadingField, itemGbc);
            itemGbc.gridy = 2;
            singleTestItemPanel.add((Component)new JLabel("Aufgabentext:"), itemGbc);
            itemGbc.gridy = 3;
            itemGbc.weighty = 1.0;
            JTextArea taskContentArea = new JTextArea(5, 40);
            taskContentArea.setLineWrap(true);
            taskContentArea.setWrapStyleWord(true);
            JScrollPane taskContentScrollPane = new JScrollPane(taskContentArea);
            singleTestItemPanel.add((Component)taskContentScrollPane, itemGbc);
            itemGbc.gridy = 4;
            itemGbc.weighty = 0.0;
            singleTestItemPanel.add((Component)new JLabel("L\u00f6sungstext:"), itemGbc);
            itemGbc.gridy = 5;
            itemGbc.weighty = 1.0;
            JTextArea solutionContentArea = new JTextArea(5, 40);
            solutionContentArea.setLineWrap(true);
            solutionContentArea.setWrapStyleWord(true);
            JScrollPane solutionContentScrollPane = new JScrollPane(solutionContentArea);
            singleTestItemPanel.add((Component)solutionContentScrollPane, itemGbc);
            singleTestItemPanel.putClientProperty("testHeading", testHeadingField);
            singleTestItemPanel.putClientProperty("taskContent", taskContentArea);
            singleTestItemPanel.putClientProperty("solutionContent", solutionContentArea);
            testItemsContainerPanel.add(singleTestItemPanel);
            testItemsContainerPanel.revalidate();
            testItemsContainerPanel.repaint();
            testItemsScrollPane.getVerticalScrollBar().setValue(testItemsScrollPane.getVerticalScrollBar().getMaximum());
        };
        JButton addTestItemButton = new JButton("Testaufgabe hinzuf\u00fcgen");
        addTestItemButton.addActionListener(e -> addTestItem.run());
        addTestItem.run();
        panel.add((Component)inputPanel, "North");
        panel.add((Component)testItemsScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(addTestItemButton);
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String themeClass = this.getSelectedThemeClass(themeComboBox);
            String mainTitle = mainTitleField.getText().trim();
            if (mainTitle.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie den Haupttitel des Testblocks aus.", "Fehler", 0);
                return;
            }
            StringBuilder allTestItemsHtml = new StringBuilder();
            Component[] componentArray = testItemsContainerPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JPanel) {
                    String[] solutionLines;
                    String[] taskLines;
                    JPanel itemPanel = (JPanel)comp;
                    JTextField testHeadingField = (JTextField)itemPanel.getClientProperty("testHeading");
                    JTextArea taskContentArea = (JTextArea)itemPanel.getClientProperty("taskContent");
                    JTextArea solutionContentArea = (JTextArea)itemPanel.getClientProperty("solutionContent");
                    String testHeading = testHeadingField.getText().trim();
                    String rawTaskContent = taskContentArea.getText();
                    String rawSolutionContent = solutionContentArea.getText();
                    if (testHeading.isEmpty() || rawTaskContent.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Testaufgabenfelder aus.", "Fehler", 0);
                        return;
                    }
                    StringBuilder formattedTaskContent = new StringBuilder();
                    String[] stringArray = taskLines = rawTaskContent.split("\n");
                    int n3 = taskLines.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray[n4];
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") || trimmedLine.startsWith("&lt;")) {
                            formattedTaskContent.append("                            ").append(trimmedLine).append("\n");
                        } else if (!trimmedLine.isEmpty()) {
                            formattedTaskContent.append("                            <p>").append(trimmedLine).append("</p>\n");
                        } else {
                            formattedTaskContent.append("\n");
                        }
                        ++n4;
                    }
                    StringBuilder formattedSolutionContent = new StringBuilder();
                    String[] stringArray2 = solutionLines = rawSolutionContent.split("\n");
                    int n5 = solutionLines.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String line = stringArray2[n6];
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") || trimmedLine.startsWith("&lt;")) {
                            formattedSolutionContent.append("                                ").append(trimmedLine).append("\n");
                        } else if (!trimmedLine.isEmpty()) {
                            formattedSolutionContent.append("                                <p>").append(trimmedLine).append("</p>\n");
                        } else {
                            formattedSolutionContent.append("\n");
                        }
                        ++n6;
                    }
                    allTestItemsHtml.append(String.format("                <div class=\"test-item\">\n                    <h4>%s</h4>\n%s\n                    <div class=\"solution-toggle\">L\u00f6sung anzeigen\n                        <i class=\"fas fa-chevron-down toggle-icon\"></i>\n                    </div>\n\n                    <div class=\"solution-content\">\n%s                    </div>\n                </div>\n", testHeading, formattedTaskContent.toString().trim(), formattedSolutionContent.toString().trim()));
                }
                ++n2;
            }
            String html = String.format("<div class=\"test-block %s\">\n    <img src=\"../../Bilder/Symbol-Test-Fragen.png\" alt=\"Test Icon\" class=\"test-icon-floated\">\n    <h3>%s</h3>\n\n%s</div>", themeClass, mainTitle, allTestItemsHtml.toString().trim());
            this.outputTextArea.setText(html);
        });
        bottomPanel.add(generateButton);
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JPanel createVideoBlockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Videoblock Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Thema (Farbe des Blocks):"), gbc);
        gbc.gridx = 1;
        JComboBox<String> themeComboBox = this.createThemeComboBox();
        panel.add(themeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Titel des Videos:"), gbc);
        gbc.gridx = 1;
        JTextField videoTitleField = new JTextField(30);
        panel.add((Component)videoTitleField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Video-Typ:"), gbc);
        gbc.gridx = 1;
        String[] videoTypes = new String[]{"Extern (YouTube/Vimeo)", "Lokal"};
        JComboBox<String> videoTypeComboBox = new JComboBox<String>(videoTypes);
        panel.add(videoTypeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        JLabel pathOrIframeLabel = new JLabel("Pfad zur lokalen Videodatei / IFRAME-Code:");
        panel.add((Component)pathOrIframeLabel, gbc);
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JTextArea pathOrIframeArea = new JTextArea(8, 50);
        pathOrIframeArea.setLineWrap(true);
        pathOrIframeArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(pathOrIframeArea);
        panel.add((Component)scrollPane, gbc);
        videoTypeComboBox.addActionListener(e -> {
            if ("Extern (YouTube/Vimeo)".equals(videoTypeComboBox.getSelectedItem())) {
                pathOrIframeLabel.setText("Vollst\u00e4ndiger IFRAME-Einbettungscode:");
                pathOrIframeArea.setText("");
            } else {
                pathOrIframeLabel.setText("Pfad zur lokalen Videodatei (z.B. 'Pfad/zu/deinem/lokalen/video.mp4'):");
                pathOrIframeArea.setText("");
            }
        });
        videoTypeComboBox.setSelectedItem("Extern (YouTube/Vimeo)");
        pathOrIframeLabel.setText("Vollst\u00e4ndiger IFRAME-Einbettungscode:");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)new JLabel("Optionaler Text unter dem Video (leer lassen f\u00fcr keinen Text):"), gbc);
        gbc.gridy = 6;
        JTextField optionalTextField = new JTextField(50);
        panel.add((Component)optionalTextField, gbc);
        gbc.gridy = 7;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String themeClass = this.getSelectedThemeClass(themeComboBox);
            String videoTitle = videoTitleField.getText().trim();
            String selectedVideoType = (String)videoTypeComboBox.getSelectedItem();
            String pathOrIframeContent = pathOrIframeArea.getText().trim();
            String optionalText = optionalTextField.getText().trim();
            if (videoTitle.isEmpty() || pathOrIframeContent.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie Titel und Video-Pfad/Iframe-Inhalt aus.", "Fehler", 0);
                return;
            }
            String videoContentHtml = "";
            String pTagContent = "";
            videoContentHtml = "Extern (YouTube/Vimeo)".equals(selectedVideoType) ? String.format("                    <div class=\"video-container\">\n                        %s\n                    </div>", pathOrIframeContent) : String.format("                    <div class=\"video-container\">\n                        <video controls data-src=\"%s\"></video>\n                    </div>", pathOrIframeContent);
            if (!optionalText.isEmpty()) {
                pTagContent = String.format("                    <p>%s</p>\n", optionalText);
            }
            String html = String.format("<div class=\"video-block active %s\">\n    <img src=\"../../Bilder/Symbol-Video.png\" alt=\"Video Icon\" class=\"video-icon-floated\">\n\n    <div class=\"video-block-toggle\">\n        <span class=\"title\">%s</span>\n        <i class=\"fas fa-chevron-down toggle-icon\"></i>\n    </div>\n\n    <div class=\"video-block-content\">\n%s\n%s    </div>\n</div>", themeClass, videoTitle, videoContentHtml, pTagContent);
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createTextImageBlockPanel(String floatDirection) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Text mit Bild (" + floatDirection + ") Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Pfad zum Bild (src):"), gbc);
        gbc.gridx = 1;
        JTextField imgSrcField = new JTextField(40);
        panel.add((Component)imgSrcField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Alt-Beschreibung:"), gbc);
        gbc.gridx = 1;
        JTextField imgAltField = new JTextField(40);
        panel.add((Component)imgAltField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Bildbreite (z.B. '10%', '25%', '50%'):"), gbc);
        gbc.gridx = 1;
        JTextField imgWidthField = new JTextField(10);
        panel.add((Component)imgWidthField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Textinhalt (Abs\u00e4tze mit <p>, Listen mit <ol>/<ul> direkt eingeben):"), gbc);
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JTextArea contentTextArea = new JTextArea(10, 50);
        contentTextArea.setLineWrap(true);
        contentTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(contentTextArea);
        panel.add((Component)scrollPane, gbc);
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String[] lines;
            String imgSrc = imgSrcField.getText().trim();
            String imgAlt = imgAltField.getText().trim();
            String imgWidth = imgWidthField.getText().trim();
            String rawContent = contentTextArea.getText();
            if (imgSrc.isEmpty() || imgAlt.isEmpty() || imgWidth.isEmpty() || rawContent.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Felder aus.", "Fehler", 0);
                return;
            }
            String floatClass = "image-float-" + floatDirection;
            StringBuilder formattedContent = new StringBuilder();
            String[] stringArray = lines = rawContent.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">")) {
                    formattedContent.append("                ").append(trimmedLine).append("\n");
                } else if (!trimmedLine.isEmpty()) {
                    formattedContent.append("                <p>\n                    ").append(trimmedLine).append("\n                </p>\n");
                } else {
                    formattedContent.append("\n");
                }
                ++n2;
            }
            String html = String.format("<div class=\"text-image-block\">\n    <img src=\"%s\" alt=\"%s\" class=\"%s\" width=\"%s\">\n%s</div>", imgSrc, imgAlt, floatClass, imgWidth, formattedContent.toString().trim());
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private JPanel createImageRowBlockPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Bilderreihe Block Einstellungen"));
        JPanel imagesContainerPanel = new JPanel();
        imagesContainerPanel.setLayout(new BoxLayout(imagesContainerPanel, 1));
        JScrollPane imagesScrollPane = new JScrollPane(imagesContainerPanel);
        imagesScrollPane.setPreferredSize(new Dimension(600, 300));
        imagesScrollPane.setBorder(BorderFactory.createTitledBorder("Bilder in der Reihe"));
        AtomicInteger imageCounter = new AtomicInteger(1);
        Runnable addImage = () -> {
            JPanel singleImagePanel = new JPanel(new GridBagLayout());
            singleImagePanel.setBorder(BorderFactory.createTitledBorder("Bild " + imageCounter.getAndIncrement()));
            GridBagConstraints imgGbc = new GridBagConstraints();
            imgGbc.insets = new Insets(5, 5, 5, 5);
            imgGbc.fill = 2;
            imgGbc.weightx = 1.0;
            imgGbc.gridx = 0;
            imgGbc.gridy = 0;
            singleImagePanel.add((Component)new JLabel("Pfad zum Bild (src):"), imgGbc);
            imgGbc.gridx = 1;
            JTextField imgSrcField = new JTextField(40);
            singleImagePanel.add((Component)imgSrcField, imgGbc);
            imgGbc.gridx = 0;
            imgGbc.gridy = 1;
            singleImagePanel.add((Component)new JLabel("Alt-Beschreibung:"), imgGbc);
            imgGbc.gridx = 1;
            JTextField imgAltField = new JTextField(40);
            singleImagePanel.add((Component)imgAltField, imgGbc);
            imgGbc.gridx = 0;
            imgGbc.gridy = 2;
            singleImagePanel.add((Component)new JLabel("Bildunterschrift (optional):"), imgGbc);
            imgGbc.gridx = 1;
            JTextField figcaptionField = new JTextField(40);
            singleImagePanel.add((Component)figcaptionField, imgGbc);
            singleImagePanel.putClientProperty("imgSrc", imgSrcField);
            singleImagePanel.putClientProperty("imgAlt", imgAltField);
            singleImagePanel.putClientProperty("figcaption", figcaptionField);
            imagesContainerPanel.add(singleImagePanel);
            imagesContainerPanel.revalidate();
            imagesContainerPanel.repaint();
            imagesScrollPane.getVerticalScrollBar().setValue(imagesScrollPane.getVerticalScrollBar().getMaximum());
        };
        JButton addImageButton = new JButton("Bild hinzuf\u00fcgen");
        addImageButton.addActionListener(e -> addImage.run());
        addImage.run();
        panel.add((Component)imagesScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(addImageButton);
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            StringBuilder allFiguresHtml = new StringBuilder();
            Component[] componentArray = imagesContainerPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JPanel) {
                    JPanel imgPanel = (JPanel)comp;
                    JTextField imgSrcField = (JTextField)imgPanel.getClientProperty("imgSrc");
                    JTextField imgAltField = (JTextField)imgPanel.getClientProperty("imgAlt");
                    JTextField figcaptionField = (JTextField)imgPanel.getClientProperty("figcaption");
                    String imgSrc = imgSrcField.getText().trim();
                    String imgAlt = imgAltField.getText().trim();
                    String figcaption = figcaptionField.getText().trim();
                    if (imgSrc.isEmpty() || imgAlt.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie Pfad und Alt-Beschreibung f\u00fcr alle Bilder aus.", "Fehler", 0);
                        return;
                    }
                    String figcaptionHtml = figcaption.isEmpty() ? "" : String.format("\n                        <figcaption>%s</figcaption>", figcaption);
                    allFiguresHtml.append(String.format("                    <figure>\n                        <img src=\"%s\" alt=\"%s\">%s\n                    </figure>\n", imgSrc, imgAlt, figcaptionHtml));
                }
                ++n2;
            }
            if (allFiguresHtml.length() == 0) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcgen Sie mindestens ein Bild hinzu.", "Fehler", 0);
                return;
            }
            String html = String.format("<div class=\"image-row-block\">\n    <div class=\"image-row-container\">\n%s    </div>\n</div>", allFiguresHtml.toString());
            this.outputTextArea.setText(html);
        });
        bottomPanel.add(generateButton);
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JPanel createGalleryBlockPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Galerie Block Einstellungen"));
        JPanel slidesContainerPanel = new JPanel();
        slidesContainerPanel.setLayout(new BoxLayout(slidesContainerPanel, 1));
        JScrollPane slidesScrollPane = new JScrollPane(slidesContainerPanel);
        slidesScrollPane.setPreferredSize(new Dimension(600, 300));
        slidesScrollPane.setBorder(BorderFactory.createTitledBorder("Bilder in der Galerie"));
        AtomicInteger slideCounter = new AtomicInteger(1);
        Runnable addSlide = () -> {
            JPanel singleSlidePanel = new JPanel(new GridBagLayout());
            singleSlidePanel.setBorder(BorderFactory.createTitledBorder("Galerie Bild " + slideCounter.getAndIncrement()));
            GridBagConstraints slideGbc = new GridBagConstraints();
            slideGbc.insets = new Insets(5, 5, 5, 5);
            slideGbc.fill = 2;
            slideGbc.weightx = 1.0;
            slideGbc.gridx = 0;
            slideGbc.gridy = 0;
            singleSlidePanel.add((Component)new JLabel("Pfad zum Bild (src):"), slideGbc);
            slideGbc.gridx = 1;
            JTextField imgSrcField = new JTextField(40);
            singleSlidePanel.add((Component)imgSrcField, slideGbc);
            slideGbc.gridx = 0;
            slideGbc.gridy = 1;
            singleSlidePanel.add((Component)new JLabel("Alt-Beschreibung:"), slideGbc);
            slideGbc.gridx = 1;
            JTextField imgAltField = new JTextField(40);
            singleSlidePanel.add((Component)imgAltField, slideGbc);
            slideGbc.gridx = 0;
            slideGbc.gridy = 2;
            singleSlidePanel.add((Component)new JLabel("Bildunterschrift (optional):"), slideGbc);
            slideGbc.gridx = 1;
            JTextField figcaptionField = new JTextField(40);
            singleSlidePanel.add((Component)figcaptionField, slideGbc);
            singleSlidePanel.putClientProperty("imgSrc", imgSrcField);
            singleSlidePanel.putClientProperty("imgAlt", imgAltField);
            singleSlidePanel.putClientProperty("figcaption", figcaptionField);
            slidesContainerPanel.add(singleSlidePanel);
            slidesContainerPanel.revalidate();
            slidesContainerPanel.repaint();
            slidesScrollPane.getVerticalScrollBar().setValue(slidesScrollPane.getVerticalScrollBar().getMaximum());
        };
        JButton addSlideButton = new JButton("Bild zur Galerie hinzuf\u00fcgen");
        addSlideButton.addActionListener(e -> addSlide.run());
        addSlide.run();
        panel.add((Component)slidesScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(addSlideButton);
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            StringBuilder allSlidesHtml = new StringBuilder();
            Component[] componentArray = slidesContainerPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JPanel) {
                    JPanel slidePanel = (JPanel)comp;
                    JTextField imgSrcField = (JTextField)slidePanel.getClientProperty("imgSrc");
                    JTextField imgAltField = (JTextField)slidePanel.getClientProperty("imgAlt");
                    JTextField figcaptionField = (JTextField)slidePanel.getClientProperty("figcaption");
                    String imgSrc = imgSrcField.getText().trim();
                    String imgAlt = imgAltField.getText().trim();
                    String figcaption = figcaptionField.getText().trim();
                    if (imgSrc.isEmpty() || imgAlt.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie Pfad und Alt-Beschreibung f\u00fcr alle Galeriebilder aus.", "Fehler", 0);
                        return;
                    }
                    String figcaptionHtml = figcaption.isEmpty() ? "" : String.format("\n                                <figcaption>%s</figcaption>", figcaption);
                    allSlidesHtml.append(String.format("                        <div class=\"gallery-image-slide\">\n                            <figure>\n                                <img src=\"%s\" alt=\"%s\">%s\n                            </figure>\n                        </div>\n", imgSrc, imgAlt, figcaptionHtml));
                }
                ++n2;
            }
            if (allSlidesHtml.length() == 0) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcgen Sie mindestens ein Bild zur Galerie hinzu.", "Fehler", 0);
                return;
            }
            String html = String.format("<div class=\"gallery-block\">\n    <div class=\"gallery-container\">\n        <div class=\"gallery-images-container\">\n%s        </div>\n\n        <div class=\"gallery-nav\">\n            <div class=\"gallery-arrow arrow-left\">\n                <i class=\"fas fa-chevron-left\"></i>\n            </div>\n            <div class=\"gallery-arrow arrow-right\">\n                <i class=\"fas fa-chevron-right\"></i>\n            </div>\n        </div>\n    </div>\n    <div class=\"gallery-dots\">\n    </div>\n</div>", allSlidesHtml.toString());
            this.outputTextArea.setText(html);
        });
        bottomPanel.add(generateButton);
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JPanel createTableBlockPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Tabellen Block Einstellungen"));
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        topPanel.add((Component)new JLabel("Tabellen-Optionen:"), gbc);
        gbc.gridx = 1;
        String[] tableOptions = new String[]{"1. Ohne Linien, ohne Hintergrund, ohne Header (Standard)", "2. Mit Linien (bordered)", "3. Mit hervorgehobener Kopfzeile (header-highlight)", "4. Mit Linien und hervorgehobener Kopfzeile (bordered header-highlight)", "5. Mit Linien, hervorgehobener Kopfzeile und schattiertem Hintergrund (bordered header-highlight shaded)"};
        JComboBox<String> tableOptionsComboBox = new JComboBox<String>(tableOptions);
        topPanel.add(tableOptionsComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        topPanel.add((Component)new JLabel("Anzahl Spalten:"), gbc);
        gbc.gridx = 1;
        JSpinner numColsSpinner = new JSpinner(new SpinnerNumberModel(2, 1, 10, 1));
        topPanel.add((Component)numColsSpinner, gbc);
        panel.add((Component)topPanel, "North");
        JPanel tableContentPanel = new JPanel(new BorderLayout());
        tableContentPanel.setBorder(BorderFactory.createTitledBorder("Tabelleninhalt"));
        JScrollPane tableContentScrollPane = new JScrollPane(tableContentPanel);
        tableContentScrollPane.setPreferredSize(new Dimension(700, 400));
        panel.add((Component)tableContentScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton generateButton = new JButton("HTML generieren");
        bottomPanel.add(generateButton);
        panel.add((Component)bottomPanel, "South");
        numColsSpinner.addChangeListener(e -> this.updateTableContentPanel(tableContentPanel, (Integer)numColsSpinner.getValue()));
        this.updateTableContentPanel(tableContentPanel, (Integer)numColsSpinner.getValue());
        generateButton.addActionListener(e -> {
            String selectedOption = (String)tableOptionsComboBox.getSelectedItem();
            String tableClasses = "";
            switch (selectedOption) {
                case "2. Mit Linien (bordered)": {
                    tableClasses = "bordered";
                    break;
                }
                case "3. Mit hervorgehobener Kopfzeile (header-highlight)": {
                    tableClasses = "header-highlight";
                    break;
                }
                case "4. Mit Linien und hervorgehobener Kopfzeile (bordered header-highlight)": {
                    tableClasses = "bordered header-highlight";
                    break;
                }
                case "5. Mit Linien, hervorgehobener Kopfzeile und schattiertem Hintergrund (bordered header-highlight shaded)": {
                    tableClasses = "bordered header-highlight shaded";
                    break;
                }
            }
            int currentNumCols = (Integer)numColsSpinner.getValue();
            StringBuilder headerHtml = new StringBuilder();
            headerHtml.append("                    <thead>\n                        <tr>\n");
            int i = 0;
            while (i < currentNumCols) {
                JTextField headerField = (JTextField)((JPanel)tableContentPanel.getClientProperty("headerPanel")).getComponent(i);
                if (headerField.getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Spaltenk\u00f6pfe aus.", "Fehler", 0);
                    return;
                }
                headerHtml.append("                            <th>").append(headerField.getText().trim()).append("</th>\n");
                ++i;
            }
            headerHtml.append("                        </tr>\n                    </thead>\n");
            StringBuilder bodyHtml = new StringBuilder();
            bodyHtml.append("                    <tbody>\n");
            JPanel rowsPanel = (JPanel)tableContentPanel.getClientProperty("rowsPanel");
            if (rowsPanel == null || rowsPanel.getComponentCount() == 0) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcgen Sie mindestens eine Datenzeile hinzu.", "Fehler", 0);
                return;
            }
            Component[] componentArray = rowsPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component rowComp = componentArray[n2];
                if (rowComp instanceof JPanel) {
                    JPanel singleRowPanel = (JPanel)rowComp;
                    bodyHtml.append("                        <tr>\n");
                    int i2 = 0;
                    while (i2 < currentNumCols) {
                        JTextField cellField = (JTextField)singleRowPanel.getComponent(i2);
                        if (cellField.getText().trim().isEmpty()) {
                            JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle Datenzellen aus.", "Fehler", 0);
                            return;
                        }
                        bodyHtml.append("                            <td>").append(cellField.getText().trim()).append("</td>\n");
                        ++i2;
                    }
                    bodyHtml.append("                        </tr>\n");
                }
                ++n2;
            }
            bodyHtml.append("                    </tbody>\n");
            String html = String.format("<div class=\"table-block %s\">\n    <table>\n%s%s    </table>\n</div>", tableClasses, headerHtml.toString(), bodyHtml.toString());
            this.outputTextArea.setText(html);
        });
        return panel;
    }

    private void updateTableContentPanel(JPanel tableContentPanel, int numCols) {
        tableContentPanel.removeAll();
        tableContentPanel.setLayout(new BorderLayout());
        JPanel headerFieldsPanel = new JPanel(new GridLayout(1, numCols, 5, 5));
        int i = 0;
        while (i < numCols) {
            headerFieldsPanel.add(new JTextField("Spaltenkopf " + (i + 1)));
            ++i;
        }
        headerFieldsPanel.setBorder(BorderFactory.createTitledBorder("Spaltenk\u00f6pfe"));
        tableContentPanel.add((Component)headerFieldsPanel, "North");
        tableContentPanel.putClientProperty("headerPanel", headerFieldsPanel);
        JPanel rowsPanel = new JPanel();
        rowsPanel.setLayout(new BoxLayout(rowsPanel, 1));
        rowsPanel.setBorder(BorderFactory.createTitledBorder("Datenzeilen"));
        JScrollPane rowsScrollPane = new JScrollPane(rowsPanel);
        tableContentPanel.add((Component)rowsScrollPane, "Center");
        tableContentPanel.putClientProperty("rowsPanel", rowsPanel);
        JButton addRowButton = new JButton("Zeile hinzuf\u00fcgen");
        addRowButton.addActionListener(e -> {
            JPanel singleRowPanel = new JPanel(new GridLayout(1, numCols, 5, 5));
            int i = 0;
            while (i < numCols) {
                singleRowPanel.add(new JTextField("Daten"));
                ++i;
            }
            rowsPanel.add(singleRowPanel);
            rowsPanel.revalidate();
            rowsPanel.repaint();
            rowsScrollPane.getVerticalScrollBar().setValue(rowsScrollPane.getVerticalScrollBar().getMaximum());
        });
        JPanel rowButtonPanel = new JPanel(new FlowLayout(2));
        rowButtonPanel.add(addRowButton);
        tableContentPanel.add((Component)rowButtonPanel, "South");
        addRowButton.doClick();
        tableContentPanel.revalidate();
        tableContentPanel.repaint();
    }

    private JPanel createDownloadLinkPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Downloadlink Einstellungen"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Downloadlink Variante:"), gbc);
        gbc.gridx = 1;
        String[] linkOptions = new String[]{"1. Text mit einfachem Download-Icon", "2. Text mit Downloadsymbol ohne extra Link"};
        JComboBox<String> linkOptionComboBox = new JComboBox<String>(linkOptions);
        panel.add(linkOptionComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Pfad zur Datei (href):"), gbc);
        gbc.gridx = 1;
        JTextField filePathField = new JTextField(40);
        panel.add((Component)filePathField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Dateiname beim Download:"), gbc);
        gbc.gridx = 1;
        JTextField downloadNameField = new JTextField(40);
        panel.add((Component)downloadNameField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        JLabel optionalTextLabel = new JLabel("Anklickbarer Text:");
        panel.add((Component)optionalTextLabel, gbc);
        gbc.gridx = 1;
        JTextField optionalTextField = new JTextField(40);
        panel.add((Component)optionalTextField, gbc);
        linkOptionComboBox.addActionListener(e -> {
            if ("1. Text mit einfachem Download-Icon".equals(linkOptionComboBox.getSelectedItem())) {
                optionalTextLabel.setText("Anklickbarer Text:");
                optionalTextField.setText("");
                optionalTextField.setVisible(true);
                optionalTextLabel.setVisible(true);
            } else {
                optionalTextLabel.setText("Text vor dem Download-Symbol:");
                optionalTextField.setText("");
                optionalTextField.setVisible(true);
                optionalTextLabel.setVisible(true);
            }
        });
        linkOptionComboBox.setSelectedItem("1. Text mit einfachem Download-Icon");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        JButton generateButton = new JButton("HTML generieren");
        generateButton.addActionListener(e -> {
            String selectedOption = (String)linkOptionComboBox.getSelectedItem();
            String filePath = filePathField.getText().trim();
            String downloadName = downloadNameField.getText().trim();
            String optionalText = optionalTextField.getText().trim();
            if (filePath.isEmpty() || downloadName.isEmpty() || optionalText.isEmpty() && selectedOption.equals("1. Text mit einfachem Download-Icon")) {
                JOptionPane.showMessageDialog(this, "Bitte f\u00fcllen Sie alle erforderlichen Felder aus.", "Fehler", 0);
                return;
            }
            String html = "";
            html = "1. Text mit einfachem Download-Icon".equals(selectedOption) ? String.format("<p>Hier bekommst du das Bild als \n    <a href=\"%s\" download=\"%s\">\n        <img src=\"../../Bilder/Symbol-Download.png\" alt=\"Download Symbol\" class=\"download-icon\"> %s\n    </a>\n    Bitte klicken Sie auf das Symbol oder den Link.\n</p>", filePath, downloadName, optionalText) : String.format("<p>%s\n    <a href=\"%s\" download=\"%s\">\n        <img src=\"../../Bilder/Symbol-Download2.png\" alt=\"Download PDF\" class=\"download-icon\"> </a>\n</p>", optionalText, filePath, downloadName);
            this.outputTextArea.setText(html);
        });
        panel.add((Component)generateButton, gbc);
        return panel;
    }

    private String indentHtmlContent(String htmlContent, int initialIndentLevel) {
        StringBuilder indentedHtml = new StringBuilder();
        String[] lines = htmlContent.split("\n");
        String initialIndent = " ".repeat(initialIndentLevel);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                indentedHtml.append(initialIndent).append(line).append("\n");
            } else {
                indentedHtml.append("\n");
            }
            ++n2;
        }
        return indentedHtml.toString();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            HtmlBlockGeneratorGUI htmlBlockGeneratorGUI = new HtmlBlockGeneratorGUI();
        });
    }
}

